// ========================================================
//
// Kazakhstan Data Cleaning
// Tom Gaut
//
// ========================================================

	clear all
	cls
	set more off, permanently
	global data "C:\Users\thoma\Documents\NIDI Stage\Syntax\GGS1-GGP2020"
	
	// Loading dataset:
	use "$data\\GGP2020_WAVE1_KAZ_V_1_0.dta", clear


	
// ========================================================
// Renaming and dropping variables before merging
// ========================================================

// Dropping variables as not in GGS1 or Belarus:
drop a1104b a1104d a1104k a1104l a1104j

// Received large financial transfer (year and person) switching:
foreach v of numlist 1/5 {
	gen a538_`v'c = a538_`v' 					  // Generate copies
	}
drop a538_1 a538_2 a538_3 a538_4 a538_5  	      // Dropping before rename
rename (a537_1 a537_2 a537_3 a537_4 a537_5) 	 ///
	   (a538_1 a538_2 a538_3 a538_4 a538_5)
rename (a538_1c a538_2c a538_3c a538_4c  a538_5c) ///
	   (a537_1 a537_2 a537_3 a537_4 a537_5)
	   
// Renaming Values variables to fit with GGS1:
rename (a1104a a1104c a1104e a1104h a1104g a1104f a1104i)	///
	   (a1107_a a1107_c a1107_e a1107_f a1107_g a1107_h a1107_i)

// Recoding intentions to have child to fit with GGS1:
rename a614 a624
recode a624 (1 = 1) (2 = 2) (3 = 5) (4 = 3) (5 = 4)


// ========================================= END OF SECTION



// ========================================================
// Saving and appending to Belarus
// ========================================================

// Save as copy:
save "$data\\kazakh_data_temp.dta", replace

// Load the Belarus data:
use "$data\\GGP2020_WAVE1_BLR_V_1_0.dta", clear

// Appending files together:
append using "$data\\kazakh_data_temp.dta"

// Adding country labels:
label define acountry 30 "Belarus" 34 "Kazakhstan", modify
codebook acountry

// Adding region labels:
label define _aregion 1 "Brest"						///
					  2 "Vitebsk"					///
					  3 "Gomel"						///
					  4 "Grodno"					///
					  5 "Minsk"						///
					  6 "Mogilev"					///
					  7 "Minsk City"				///
					  11 "Akmolinskaya" 			///
					  15 "Aktubinskaya" 	 		///
					  19 "Almatinskaya"  			///
					  23 "Atyrauskaya"  	 		///
					  27 "West-Kazakhstanskaya"     ///
					  31 "Zhambylskaya" 			///
					  35 "Karagandinskaya" 			///
					  39 "Kostanaiskaya" 			///
					  43 "Kyzylordinskaya" 			///
					  47 "Mangistauskaya"			///
					  51 "South-Kazakhstanskaya"	///
					  55 "Pavlodarskaya" 			///
					  59 "North-Kazakhstanskaya"	///
					  63 "East-Kazakhstanskaya"		///
					  71 "Astana"					///
					  75 "Almaty"
label values aregion _aregion

// Saving for merging onto GGS1:
save "$data\\data_kazak_belarus.dta", replace
erase "$data\\kazakh_data_temp.dta"


// ========================================= END OF SECTION	



// ========================================================
// Running Vytenis Deimantas' script -
//						combines GGS1 with GGS2020
// ========================================================

do "$data\\GGS1-GGS2020_BY_master"



// Adding country labels:
label define acountry 30 "Belarus" 34 "Kazakhstan", modify
codebook acountry

// Adding region labels:
label define aregion 1 "Brest"						///
					  2 "Vitebsk"					///
					  3 "Gomel"						///
					  4 "Grodno"					///
					  5 "Minsk"						///
					  6 "Mogilev"					///
					  7 "Minsk City"				///
					  11 "Akmolinskaya" 			///
					  15 "Aktubinskaya" 	 		///
					  19 "Almatinskaya"  			///
					  23 "Atyrauskaya"  	 		///
					  27 "West-Kazakhstanskaya"     ///
					  31 "Zhambylskaya" 			///
					  35 "Karagandinskaya" 			///
					  39 "Kostanaiskaya" 			///
					  43 "Kyzylordinskaya" 			///
					  47 "Mangistauskaya"			///
					  51 "South-Kazakhstanskaya"	///
					  55 "Pavlodarskaya" 			///
					  59 "North-Kazakhstanskaya"	///
					  63 "East-Kazakhstanskaya"		///
					  71 "Astana"					///
					  75 "Almaty", modify

					  
label define a622 5 "Unsure", modify

// ========================================= END OF SECTION	



// ========================================================
// Recoding variables to match GGS1 to GGS2020
// ========================================================

// Sorting out activity status (a106/aactstat):
recode aactstat (2 3 = 1) (4 = 2) (5 = 3) (1 = 4) (6 = 5) 	///
				(9 10 = 6) (11 = 7) (8 = 8) (7 = 9) 		///
				(12 = 10) 									///
				if acountry == 30 | acountry == 34
label define aactstat 1 "employed or self-employed"					///
					  2 "helping family member in family business"	///
					  3 "unemployed"								///
					  4 "student,in school,vocational training"		///
					  5 "retired"									///
					  6 "maternity,parental,childcare leave"		///
					  7 "ill or disabled for a long time"			///
					  8 "looking after the home or family"			///
					  9 "military service or social service"		///
					  10 "other"									///
					  11 "working pensioner"						///
					  12 "in apprenticeship or paid training", modify

// Sorting out education (aeduc):		  
recode aeduc (0 = 0) (1 = 1) (2 = 2) (3 = 3) (4 = 4) 			///
			 (5 6 7 = 5) (8 = 6) 								///
			 if acountry == 30 | acountry == 34
			 // Recoded ISCED 2011 to match ISCED 1997 used in GGS1
label define aeduc 0 "isced 0 - pre-primary education"			///
				   1 "isced 1 - primary level"					///
				   2 "isced 2 - lower secondary level"			///
				   3 "isced 3 - upper secondary level"			///
				   4 "isced 4 - post secondary non-tertiary"	///
				   5 "isced 5 - first stage of tertiary"		///
				   6 "isced 6 - second stage of tertiary", modify

label define a624 5 "unsure", modify
				   
// Saving final file:		   
save "$data\\GGS1-GGS2020_master.dta", replace
				   

// ========================================= END OF SECTION										



