*** Data harmonisation for GGS1 and GGS2020 Belarus

/*WORK ON GGS2020 BELARUS DATA SET BEFORE APPENDING TO GGS1

Renaming GGS2020 BELARUS variables using GGS1 names (only applicable to variables that are in both data sets)

Variable lables correspond to GGS2020/GGS1 respectively

i.e. change from GGS2020_NAME to GGS1_NAME
 
*/

* PREPARE GGS2020 BELARUS FILE FOR APPENDING TO GGS1_MASTER

use "$data\\GGP2020_WAVE1_BLR_V_1_0.dta"

***Others present at interview/Presence of others at interview 

rename a1302a Int_pres

*** R identification number/respid

rename  respid arid

*** Month of Interview [MONTH]/Mnth of interview

rename intdatem amonth

*** Year of Interview [YEAR]/ Yr of interview

rename intdatey ayear

*** Household Size/Household size including Respondent

rename hhsize ahhsize

*** Activity Status/Activity Status Respondent

rename a106 aactstat

*** Type of Dwelling/ Type of dwelling where R lives

rename a1202 adwell

*** Education Level (ISCED 2011)/Highest Education Level of Respondent

rename  a107 aeduc

*** Floor on which R lives/ Floor number on which R lives

rename a1203 afloor

*** Living with Partner/Partner living in household of respondent

rename  a210a livingwithpartner

*** Date started living with Partner [MONTH] / Mnth starting living together

rename a210bm a301m

*** Date started living with Partner [YEAR] / Yr starting living together

rename a210by a301y

*** Born in Country/Born in country of interview?

rename a103 a105

*** Country of Birth/Country of birth

rename a104b a106b

*** Number of Rooms/Number of rooms

rename a110 a119

*** Housing Satisfaction/Satisfaction with dwelling (see satisfaction scale)

rename a113 a145

*** Childcare Tasks: dressing/ HH tasks with children:Dressing

rename a313a a201a_a

*** Childcare Tasks: putting children to bed/ HH tasks with children: Putting to bed

rename a313e a201a_b

*** Childcare Tasks: stay with ill children/HH tasks with children: Illness

rename a313b a201a_c

*** Childcare Tasks: homework/ HH tasks with children: Homework preparations

rename a313d a201a_e

*** Childcare Tasks Satisfaction/Satisfaction child care task arrangements (see satisfaction scale)

rename a314 a202

*** Regular childcare (institutional / from whom childcare is a job)/ Regular help with child care (institutional/paid arrangement)

rename a507a a203a

***Partner Born in Country/Is partner born in the country

rename a204a a303a

*** Regular help with childcare (from whom caring for children is not a job)/ Regular help with child care (for whom caring for children is not a job)

rename a503 a204a

*** Look After Children: SN Person Number/ Person 1 from whom help is received

rename a502_1 a204b_1

*** Look After Children: SN Person Number/ Person 2 from whom help is received

rename a502_2 a204b_2

*** Look After Children: SN Person Number/ Person 3 from whom help is received

rename a502_3 a204b_3

*** Look After Children: SN Person Number/ Person 4 from whom help is received

rename a502_4 a204b_4

*** Look After Children: SN Person Number/ Person 5 from whom help is received

rename a502_5 a204b_5

*** Freq. of regular childcare (from whom childcare is not a job): Person 1/ Freq. help with child care from person 1

rename a505_1 a204c_1

*** Freq. of regular childcare (from whom childcare is not a job): Person 2/ Freq. help with child care from person 2

rename a505_2 a204c_2

*** Freq. of regular childcare (from whom childcare is not a job): Person 3/ Freq. help with child care from person 3

rename a505_3 a204c_3

*** Freq. of regular childcare (from whom childcare is not a job): Person 4/ Freq. help with child care from person 4

rename a505_4 a204c_4

*** Freq. of regular childcare (from whom childcare is not a job): Person 5/ Freq. help with child care from person 5

rename a505_5 a204c_5

*** Freq. of regular childcare (from whom childcare is not a job): Person 1 [UNIT]/ Time unit freq. of help with child care from person 1

rename a505u_1 a204cu_1

*** Freq. of regular childcare (from whom childcare is not a job): Person 2 [UNIT]/ Time unit freq. of help with child care from person 2

rename a505u_2 a204cu_2

*** Freq. of regular childcare (from whom childcare is not a job): Person 3 [UNIT]/ Time unit freq. of help with child care from person 3

rename a505u_3 a204cu_3

*** Freq. of regular childcare (from whom childcare is not a job): Person 4 [UNIT]/ Time unit freq. of help with child care from person 4

rename a505u_4 a204cu_4

*** Freq. of regular childcare (from whom childcare is not a job): Person 5 [UNIT]/ Time unit freq. of help with child care from person 5

rename a505u_5 a204cu_5

*** Education Level of Partner (ISCED 2011)/ Highest education level of the current partner (country-spec. list)

rename a205 a308

*** Cost of Childcare/ Personal costs for child care

rename a508 a205

*** Cost of Childcare [UNIT]/ Time unit of personal costs for child care

rename a508u a205u

*** How long it takes to get to child 1/ Time (mins) to reach home of nonresident child 1

rename a235_1 a221t_1

*** How long it takes to get to child 2/ Time (mins) to reach home of nonresident child 2

rename a235_2 a221t_2

*** How long it takes to get to child 3/ Time (mins) to reach home of nonresident child 3

rename a235_3 a221t_3

*** How long it takes to get to child 4/ Time (mins) to reach home of nonresident child 4

rename a235_4 a221t_4

*** How long it takes to get to child 5/ Time (mins) to reach home of nonresident child 5

rename a235_5 a221t_5

*** How long it takes to get to child 6/ Time (mins) to reach home of nonresident child 6

rename a235_6 a221t_6

*** How long it takes to get to child 7/ Time (mins) to reach home of nonresident child 7

rename a235_7 a221t_7

*** How long it takes to get to child 8/ Time (mins) to reach home of nonresident child 8

rename a235_8 a221t_8

*** How long it takes to get to child 9/ Time (mins) to reach home of nonresident child 9

rename a235_9 a221t_9

*** How long it takes to get to child 10/ Time (mins) to reach home of nonresident child 10

rename a235_10 a221t_10

*** Freq. Looking After Child 1/ Freq. of looking after non-resident child 1

rename a260_1 a222_1

*** Freq. Looking After Child 2/ Freq. of looking after non-resident child 2

rename a260_2 a222_2

*** Freq. Looking After Child 3/ Freq. of looking after non-resident child 3

rename a260_3 a222_3

*** Freq. Looking After Child 4/ Freq. of looking after non-resident child 4

rename a260_4 a222_4

*** Freq. Looking After Child 5/ Freq. of looking after non-resident child 5

rename a260_5 a222_5

*** Freq. Looking After Child 6/ Freq. of looking after non-resident child 6

rename a260_6 a222_6

*** Freq. Looking After Child 7/ Freq. of looking after non-resident child 7

rename a260_7 a222_7

*** Freq. Looking After Child 8/ Freq. of looking after non-resident child 8

rename a260_8 a222_8

*** Freq. Looking After Child 9 / Freq. of looking after non-resident child 9

rename a260_9 a222_9

*** Freq. look after child 1 [UNIT] / Time unit of freq. of looking after non-resident child 1

rename a233u_1 a222u_1

*** Freq. look after child 2 [UNIT] / Time unit of freq. of looking after non-resident child 2

rename a233u_2 a222u_2

*** Freq. look after child 3 [UNIT] / Time unit of freq. of looking after non-resident child 3

rename a233u_3 a222u_3

*** Freq. look after child 4 [UNIT] / Time unit of freq. of looking after non-resident child 4

rename a233u_4 a222u_4

*** Freq. look after child 5 [UNIT] / Time unit of freq. of looking after non-resident child 5

rename a233u_5 a222u_5

*** Freq. look after child 6 [UNIT] / Time unit of freq. of looking after non-resident child 6

rename a233u_6 a222u_6

*** Freq. look after child 7 [UNIT] / Time unit of freq. of looking after non-resident child 7

rename a233u_7 a222u_7

*** Freq. look after child 8 [UNIT] / Time unit of freq. of looking after non-resident child 8

rename a233u_8 a222u_8

*** Freq. look after child 9 [UNIT] / Time unit of freq. of looking after non-resident child 9

rename a233u_9 a222u_9

*** Freq. sees child 1 / Number of meetings with nonresident child 1

rename a234_1 a223_1

*** Freq. sees child 2 / Number of meetings with nonresident child 2

rename a234_2 a223_2

*** Freq. sees child 3 / Number of meetings with nonresident child 3

rename a234_3 a223_3

*** Freq. sees child 4 / Number of meetings with nonresident child 4

rename a234_4 a223_4

*** Freq. sees child 5 / Number of meetings with nonresident child 5

rename a234_5 a223_5

*** Freq. sees child 6 / Number of meetings with nonresident child 6

rename a234_6 a223_6

*** Freq. sees child 7 / Number of meetings with nonresident child 7

rename a234_7 a223_7

*** Freq. sees child 8 / Number of meetings with nonresident child 8

rename a234_8 a223_8

*** Freq. sees child 9 / Number of meetings with nonresident child 9

rename a234_9 a223_9

*** Freq. sees child 10 / Number of meetings with nonresident child 10

rename a234_10 a223_10

*** Freq. sees child 11 / Number of meetings with nonresident child 11

rename a234_11 a223_11

*** Freq. sees child 12 / Number of meetings with nonresident child 12

rename a234_12 a223_12

*** Freq. sees child 13 / Number of meetings with nonresident child 13

rename a234_13 a223_13


*** How often sees child 1 - 12 [UNIT] / Time unit of number of meetings with non-resident child 1 - 12

rename (a234u_1 a234u_2 a234u_3 a234u_4 a234u_5 a234u_6 a234u_7 a234u_8 a234u_9 a234u_10 a234u_11 a234u_12 ) (a223u_1 a223u_2 a223u_3 a223u_4 a223u_5 a223u_6 a223u_7 a223u_8 a223u_9 a223u_10 a223u_11 a223u_12 )

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename (a224_1 a224_2 a224_3 a224_4 a224_5 a224_6 a224_7 a224_8 a224_9 a224_10 a224_11 ) (childalive_1 childalive_2 childalive_3 childalive_4 childalive_5 childalive_6 childalive_7 childalive_8 childalive_9 childalive_10 childalive_11)

*** Satisfaction with the relationship with non-resident child 1 - 11 / Relationship satisfaction with child 1 - 11 

rename  (a236_1 a236_2 a236_3 a236_4 a236_5 a236_6 a236_7 a236_8 a236_9 a236_10 a236_11) (a224_1 a224_2 a224_3 a224_4 a224_5 a224_6 a224_7 a224_8 a224_9 a224_10 a224_11)

*** Respondent has adopted children with current partner / Ever had any foster children

rename a237 a225

*** Number of step children / Total number of step children

rename numstep numstep


*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename (a231_1 a231_2 a231_3 a231_4 a231_5 a231_6 a231_7 a231_8 a231_9 a231_10 ) (childlimit_1 childlimit_2 childlimit_3 childlimit_4 childlimit_5 childlimit_6 childlimit_7 childlimit_8 childlimit_9 childlimit_10)

*** Membership hh > 3 mnths of Child 1 - 10 / Membership hh >= 3 mnths non-resident stepchild 1 -10

rename  (a259_1 a259_2 a259_3 a259_4 a259_5 a259_6 a259_7 a259_8 a259_9 a259_10 ) (a231_1 a231_2 a231_3 a231_4 a231_5 a231_6 a231_7 a231_8 a231_9 a231_10 ) 


*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a238 no_grandchild

*** Number of Grandchildren / Number of grandchildren

rename a291 a238

*** When oldest grandchild was born [MONTH] / Mnth of birth of the oldest grandchild

rename a292am a239am

*** When oldest grandchild was born [YEAR] / Yr of birth of the oldest grandchild
 
rename a292ay a239ay

*** When only grandchild was born [MONTH] / Mnth of birth of the only grandchild

rename a292bm a239bm

*** When only grandchild was born [YEAR] / Yr of birth of the only grandchild

rename a292by a239by

*** When youngest grandchild was born [MONTH] / Mnth of birth of the youngest grandchild

rename a293m a240m

*** When youngest grandchild was born [YEAR] / Yr of birth of the youngest grandchild

rename a293y a240y

*** Has great-grandchild / Any great grandchildren

rename a294a a242a

*** Number of great-grandchildren / Number of great grandchildren

rename a294b a242b

*** Renaming a variable only used in GGS2020 (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename (a252_1 a252_2 a252_3 a252_4 a252_5 a252_6 a252_7 a252_8 a252_9 a252_10 a252_11 a252_12 a252_13 a252_14 a252_15 a252_16 a252_17 a252_18 ) (parentnum_1 parentnum_2 parentnum_3 parentnum_4 parentnum_5 parentnum_6 parentnum_7 parentnum_8 parentnum_9 parentnum_10 parentnum_11 parentnum_12 parentnum_13 parentnum_14 parentnum_15 parentnum_16 parentnum_17 parentnum_18)

*** Respondent is Married to Partner / Legally married with partner

rename a208a a302a

*** Date Married Partner [MONTH] / Mnth of marriage

rename a208bm a302bm

*** Date Married Partner [YEAR] / Yr of marriage

rename a208by a302by

*** Country of Birth of Partner / Country of birth of the partner

rename a204b a303b

*** Date Relationship Started [MONTH] / Mnth starting relationship

rename a211m a311m

*** Date Relationship Started [YEAR] / Yr starting relationship

rename a211y a311y

*** Reason for living apart (most important one) / Reason for living apart

rename a212a a312a

*** Respondent reason for living apart (most important one) / R's reason for living apart (most important one)

rename a212b a312b

*** Partner reason for living apart (most important one) / Partner's reason for living apart (most important one)

rename a212c a312c

*** Circumstances for living apart (most important one) / Circumstances for living apart (most important one)

rename a212d  a312d

*** Ever married to current partner / Ever legally married with non-resident partner

rename a213 a314a

*** Year Divorced Current Partner [MONTH] / Mnth of divorce

rename a214m a314dm

*** Year Divorced Current Partner [YEAR] / Yr of divorce

rename a214y a314dy

*** Time to Current Partner Residence (minutes) / Time distance (mins) to partner's residence

rename a215 a324t

*** Number of meetings with non-resident partner / Number of meetings with non-resident partner

rename a216 a325

*** Time unit of meetings with non-resident partner / Time unit of meetings with non-resident partner

rename a216u a325u

*** Intention to start cohabiting / Intention to start living with a partner (next 3 yrs)

rename a278 a327

*** Cohabiting Opinions: Friends / Who think you should start living together: Most of your friends

rename a282a a331_a

*** Intention to marry / Intention to marry during next 3 yrs

rename a283 a332

*** Date started cohabiting Partner 1 - 9 [MONTH] / Mnth starting living together with partner 1 - 9

rename (a244m_1 a244m_2 a244m_3 a244m_4 a244m_5 a244m_6 a244m_7 a244m_8 a244m_9 ) (a334m_1 a334m_2 a334m_3 a334m_4 a334m_5 a334m_6 a334m_7 a334m_8 a334m_9 )

*** Date started cohabiting Partner 1 - 9 [YEAR] / Yr starting living together with partner 1 - 9

rename (a244y_1 a244y_2 a244y_3 a244y_4 a244y_5 a244y_6 a244y_7 a244y_8 a244y_9 ) (a334y_1 a334y_2 a334y_3 a334y_4 a334y_5 a334y_6 a334y_7 a334y_8 a334y_9 )

*** Married to Partner 1 - 9 / Was married or not with partner 1 - 9 

rename (a245a_1 a245a_2 a245a_3 a245a_4 a245a_5 a245a_6 a245a_7 a245a_8 a245a_9 )(a335a_1 a335a_2 a335a_3 a335a_4 a335a_5 a335a_6 a335a_7 a335a_8 a335a_9 )

*** Check variable for Partner 7 in GGS1 data set *** Date married Partner 1 -6 and 8 [MONTH] / Mnth marriage with partner 1 - 6 and 8

rename (a245bm_1 a245bm_2 a245bm_3 a245bm_4 a245bm_5 a245bm_6 a245bm_8) (a335m_1 a335m_2 a335m_3 a335m_4 a335m_5 a335m_6 a335m_8)

*** Check variable for Partner 7 in GGS1 data set *** Date married Partner 1 -6 and 8 [YEAR] / Yr marriage with partner 1 - 6 and 8

rename (a245by_1 a245by_2 a245by_3 a245by_4 a245by_5 a245by_6 ) (a335y_1 a335y_2 a335y_3 a335y_4 a335y_5 a335y_6 )

*** Date Partner 1 - 9 Born [MONTH] / Mnth of birth of partner 1 - 9 

rename (a246m_1 a246m_2 a246m_3 a246m_4 a246m_5 a246m_6 a246m_7 a246m_8 a246m_9 ) (a336m_1 a336m_2 a336m_3 a336m_4 a336m_5 a336m_6 a336m_7 a336m_8 a336m_9 )

*** Date Partner 1 - 9 Born [YEAR] / Yr of birth of partner 1 - 9 

rename (a246y_1 a246y_2 a246y_3 a246y_4 a246y_5 a246y_6 a246y_7 a246y_8 a246y_9 ) (a336y_1 a336y_2 a336y_3 a336y_4 a336y_5 a336y_6 a336y_7 a336y_8 a336y_9 )

*** Biological children with Partner 1 - 9 / Number of children of partner 1 - 9 

rename (a247_1 a247_2 a247_3 a247_4 a247_5 a247_6 a247_7 a247_8 a247_9 ) (a338_1 a338_2 a338_3 a338_4 a338_5 a338_6 a338_7 a338_8 a338_9 )

*** How Partnership 1 - 9 ended / How partnership 1 - 9 ends

rename (a268_1 a268_2 a268_3 a268_4 a268_5 a268_6 a268_7 a268_8 a268_9 ) (a343_1 a343_2 a343_3 a343_4 a343_5 a343_6 a343_7 a343_8 a343_9 )

*** Month Partnership 1 - 9 ended [MONTH] / Mnth of ending of partnership 1 - 9

rename (a269m_1 a269m_2 a269m_3 a269m_4 a269m_5 a269m_6 a269m_7 a269m_8 a269m_9 ) (a344m_1 a344m_2 a344m_3 a344m_4 a344m_5 a344m_6 a344m_7 a344m_8 a344m_9 )


*** Year Partnership 1 - 9 ended [YEAR] / Yr of ending of partnership 1 - 9

rename (a269y_1 a269y_2 a269y_3 a269y_4 a269y_5 a269y_6 a269y_7 a269y_8 a269y_9 ) (a344y_1 a344y_2 a344y_3 a344y_4 a344y_5 a344y_6 a344y_7 a344y_8 a344y_9 )


*** Got divorced from partner 1 - 7? / Got divorced from partner 1 - 7 

rename (a270a_1 a270a_2 a270a_3 a270a_4 a270a_5 a270a_6 a270a_7 ) (a349a_1 a349a_2 a349a_3 a349a_4 a349a_5 a349a_6 a349a_7 )

*** Date Divorced Partner 1 - 5 [MONTH] / Mnth of divorce of partnership 1 - 5

rename (a270bm_1 a270bm_2 a270bm_3 a270bm_4 a270bm_5 ) (a349m_1 a349m_2 a349m_3 a349m_4 a349m_5 )

*** Date Divorced Partner 1 - 5 [YEAR] / Yr of divorce of partnership 1 - 5

rename (a270by_1 a270by_2 a270by_3 a270by_4 a270by_5 ) (a349y_1 a349y_2 a349y_3 a349y_4 a349y_5 )

*** Who started divorce with Partner 1 - 9 / Who started the legal process of divorce of partnership 1 - 9

rename (a271_1 a271_2 a271_3 a271_4 a271_5 a271_6 a271_7 a271_8 a271_9 ) (a350_1 a350_2 a350_3 a350_4 a350_5 a350_6 a350_7 a350_8 a350_9 ) 

*** Received maintenance payments for children / Received maintenance payments for children from prev. partnership last 12 mnths

rename  a287 a354

*** Given maintenance payments for children / Paid maintenance payments for children to any prev. partnership last 12 mnths

rename a288 a358

*** Given Alimony to former partner / Had paid maintenance payments to any prev. partnership during last 12 mnths

rename a290 a366

*** Partners Date of Birth [MONTH] / Mnth of birth current partner 

*** NB: p_dobm is chosen because it has one observation more than a202m

rename p_dobm a373m

*** Partners Date of Birth [YEAR] / Yr of birth current partner 

*** NB: p_dobm is chosen because it has one observation more than a202y

rename p_doby a373y 

*** Activity Status of Partner / Current activity of current partner

rename a206 a381

*** Everyday Activities Limitation of Partner / Everyday activities limitation of the current partner

rename a207 a382

*** Sex of Partner / Sex of current partner

rename a203 a384

*** Household Tasks: preparing meals / Who does hh tasks: Preparing daily meals

rename a311a a401a_a

*** Household Tasks: vacuuming / Who does hh tasks: Vacuum-cleaning the house

rename a311b a401a_d

*** Household Tasks: small repairs / Who does hh tasks: Small repairs in, around the house

rename a311d a401a_e

*** Household Tasks: finances / Who does hh tasks: Paying bills, financial records

rename a311e a401a_f

*** Household Tasks: social / Who does hh tasks: Organizing joint social activities

rename a311f a401a_g

*** Both parents biological / Are parents biological parents

rename a402 a502

*** Household Tasks Satisfaction / Satisfaction with the division of the hh tasks (see satisfaction scale)

rename a312 a402

*** Decision Making: routine purchases / Who makes decisions about hh: Routine hh purchases

rename a315a a405a_a

*** Decision Making: expensive purchases / Who makes decisions about hh: Expensive purchases for the hh

rename a315b a405a_b

*** Decision Making: time spent working / Who makes decisions about hh: Own time in paid work

rename a315c a405a_c

*** Decision Making: time spouse spends working / Who makes decisions about hh: Your partners time in paid work

rename a315d a405a_d

*** Decision Making: raising children / Who makes decisions about hh: Way of child raising

rename a315e a405a_e

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a710 happ_scale

*** Given personal care / Any regular help given over last 12 mnths

rename a530 a710

*** Biological Father still alive / Is biological father alive

rename a406 a530

*** How income is organized / How hh income is organized

rename a316 a406

*** Living with or without parents in the HH / Living with or without parents in the hh

rename a401 a501

*** Father is biological / Is father biological father

rename a403 a503

*** Mother is biological / Is mother biological mother

rename a404 a504

*** Biological Mother still alive / Is biological mother alive

rename a405 a510

*** Date of Mother's Death [YEAR] / Yr of death of the biological mother

rename a408y a511

*** Date of Mothers Birth [YEAR] / Yr of birth of the biological mother

rename a409y a512 

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a518 cost_help

*** Everyday Activity Limitation of Mother  / Limitation or disability of the mother

rename a423 a518 

*** Duration to mother's home {MINUTES] / Time distance (mins) to mother's residence

rename a419 a520t


*** Any regular help needed in personal care / Any regular help needed in personal care

rename a521 a704

*** Freq. Of Meeting with Mother / Number of meetings with the mother

rename a421 a521

***  Freq. Of Meeting with Mother [UNIT] / Time unit of meetings

rename a421u a521u

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a522 pers_help

*** Satisfaction with the relationship with Mother / Satisfaction with relationship to mother (see satisfaction scale)

rename a422 a522

*** Intention to live with mother in next 3 years / Intention start living together with mother within next 3 yrs

rename a420 a523

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a532 fin_transfers

*** Date of Father's Birth [YEAR] / Yr of birth of the biological father

rename a425y a532

*** Is Father born in [Country] / Is father born in the country

rename a426a a533a

*** Father's Country of Birth / Country of birth of the father

rename a426b a533b

*** Everyday Activity Limitation of Father / Limitation or disability of the father

rename a434 a538

*** Duration to father's home [MINUTES] / Time distance (mins) to father's residence

rename a430 a540t

*** Freq. Of Meeting with Father /  Number of meetings with the father

rename a432 a541

*** Time Unit Freq. Of Meeting with Father [UNIT] / Time unit of meetings

rename a432u a541u

*** Satisfaction with the relationship with Father / Satisfaction with relationship to father (see satisfaction scale)

rename a433 a542

*** Intention to live with father in next 3 years / Intention start living together with father within next 3 yrs

rename a431 a543

*** Biological parents Broke Up / Did biological parents ever break up

rename a435 a550

*** Number of Brothers Alive / Number of brothers alive

rename a437b_b a5106b_b

*** Number of Sisters Alive / Number of sisters alive

rename a437b_s a5106b_s

*** Number of Grandparents Alive / Number of grandparents alive

rename a438 a5107

*** Number of Brothers / Number of brothers

rename a437a_b a5106a_b

*** Number of Sisters / Number of sisters

rename a437a_s a5106a_s

*** When first lived seperately from parents [YEAR] / Yr of first time living separately from parents >= 3 mnths

rename a452by a5116y

*** Ever lived seperately from parents / Ever had living separately from parents >= 3 mnths

rename a452a a5117a

*** Country where living during childhood, until age 15 / Place (abroad, country) where living during childhood, until age 15

rename a439c a5108_2

*** With both biological parents during childhood, until age 15 / With both biological parents during childhood, until age 15

rename a440 a5109

*** With whom R lived until age 15 / With whom R lived until age 15

rename a441 a5110

*** Quality of relationship between parents until age 15 / Quality of relationship with parents until age 15

rename a442 a5111

*** Father's occupation when R was age 15 (see code ISCO) / Father's occupation when R was age 15 (see code ISCO)

rename a443 a5112_1dig

*** Father's highest education level (see code ISCED) / Father's highest education level (see code ISCED)

rename a444 a5113

*** Mother's occupation when R was age 15 (see code ISCO) / Mother's occupation when R was age 15 (see code ISCO)

rename a445 a5114_1dig

*** Mother's highest education level (see code ISCED) / Mother's highest education level (see code ISCED)

rename a446 a5115

*** Date started living seperately from parents [MONTH] / Mnth of first time living separately from parents >= 3 mnths

rename a451m a5116m

*** Intention to start living seperately from parents / Intention to live separately from parents within the next 3 yrs

rename a453 a5118

*** Living Seperately: the possibility to do what you want / Effect living separately from parents: Possibility do what you want

rename a455a a5119_a

*** Living Seperately: your sexual life / Effect living separately from parents: Sexual life

rename a455e a5119_d

*** Living Seperately: the joy and satisfaction you get from life / Effect living separately from parents: Joy and satisfaction you get from life

rename a455d a5119_f

*** Opinions about living seperately: Partner / Does partner/spouse think that R should start living separately from parents

rename a457c a5121

*** Opinions about living seperately: Friends / Other's opinion: Most friends think R should live separately from parents

rename a457a a5122_a

*** Opinions about living seperately: Parents / Other's opinion: Parents think R should live separately from parents

rename a457b a5122_b

*** Preganancy Expectancy Date [MONTH] / Expected mnth of birth of the child

rename a602m a603m

*** Preganancy Expectancy Date [YEAR] / Expected yr of birth of the child

rename a602y a603y

**** Able to have children / Physically possible to have a child

rename a605 a612

*** Pregnancy Timing / Timing for the pregnancy

rename a604 a605

*** Pregnancy Intended / R wanted a baby before pregnancy began

rename a603 a604

*** Sterilized / Sterilized/operation that makes it impossible to  have a child

rename a606a a613a

*** Sterilization Date [MONTH] / Date (mnth) of operation

rename a606bm a613bm

*** Sterilization Date [YEAR] / Date (yr) of operation

rename a606by a613by

*** Date discovered infertility [MONTH] / Date (mnth) of finding out not being able to have more children

rename a607m a614m

*** Date discovered infertility [YEAR] / Date (yr) of finding out not being able to have more children

rename a607y a614y

*** Child Gender Preference / Preferred sex of next child

rename a616 a625

*** Partner able to have children / Physically possible for partner to have a child

rename a608 a616

*** Partner Sterilized / Sterilized/operation that makes it impossible for partner to have a child

rename a609a a617a

*** Partner Sterilization Date [MONTH] / Date (mnth) of partner's operation

rename a609bm a617bm

*** Partner Sterilization Date [YEAR] / Date (yr) of partner's operation

rename a609by a617by

*** Date of Starting Treatment [MONTH] / Starting date (mnth) of infertility treatment

rename a611m a619m

*** Date of Starting Treatment [YEAR] / Starting date (yr) of infertility treatment

rename a611y a619y

*** Date last used contraception [MONTH] / Date (mnth) of last use or do anything to prevent pregnancy

rename a613m a621m

*** Date last used contraception [YEAR] / Date (yr) of last use or do anything to prevent pregnancy

rename a613y a621y

*** Intention to have a child in next 3 years / Intentions to have a child during next 3 years

rename a614 a622

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a703a heart_condition

*** Everyday Activity Limitation / Any health-related limitation or disability

rename a705a a703a

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a706 weight

*** Received other help with personal care / Has received any regular help over last 12 mnths from other person

rename a524 a706

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a701 life_satis

*** Subjective Health / General health status

rename a702 a701


*** Loneliness: People to lean on / Current experience: Plenty of people I can lean on in case of trouble

rename a711a a720_a

*** Loneliness: General sense of emptiness / Current experience: I experience a general sense of emptiness

rename a711b a720_b

*** Loneliness: Miss having people around / Current experience: I miss having people around

rename a711c a720_c

*** Loneliness: Many people to count on / Current experience: There are many people that I can count on completely

rename a711d a720_d

*** Loneliness: Feel rejected / Current experience: Often, I feel rejected

rename a711e a720_e

*** Loneliness: Enough people I feel close to / Current experience: There are enough people that I feel close to

rename a711f a720_f

*** Depression: Could not shake off the blues / Experience R prev. week: I felt I could not shake off the blues

rename a712a a721_a

*** Depression: Felt Depressed / Experience R prev. week: I felt depressed

rename a712b a721_b

*** Depression: Felt life was a failure / Experience R prev. week: I thought my life had been a failure

rename a712c a721_c

*** Depression: Felt fearful / Experience R prev. week: I felt fearful

rename a712d a721_d

*** Depression: Felt sad / Experience R prev. week: I felt sad

rename a712e a721_g


*** Variable a801: Activity Status is not directly comparable to the same variable
*** in GGS1 because of different value labels. Therefore, values have to be reassigned.


*** Preparing GGS2020 a801 values for harmonisation with GGS1 a801 values

replace a801=111 if a801==1 /* student, in school, vocational training*/

replace a801=222 if a801==2 /* Employed*/

replace a801=333 if a801==3 /* Self-Employed*/

replace a801=444 if a801==4 /* Hepling family members in a family farm or business*/

replace a801=555 if a801==5 /* Unemployed*/

replace a801=666 if a801==6 /* Retired*/

replace a801=777 if a801==7 /* In military or civic service*/

replace a801=888 if a801==8 /* Homemaker*/

replace a801=999 if a801==9 /* On maternity leave*/

replace a801=1010 if a801==10 /* On parental leave or childcare leave*/

replace a801=1111 if a801==11 /* Ill or desabled for a long time or permanently*/

replace a801=1212 if a801==12 /* Other*/

*** Harmonising GGS2020 a801 values with GGS1 a801 values


replace a801=1 if a801==222 | a801==333 /*employed or self-employed*/

replace a801=2 if a801==444 /*helping family member in a family business*/

replace a801=3 if a801==555 /*unemployed*/

replace a801=4 if a801==111 /*student, in school, in vocational training*/

replace a801=5 if a801==666 /*retired*/

replace a801=6 if a801==999 |a801==1010 /*on maternity leave, parental leave or c*/

replace a801=7 if a801==1111 /* ill or disabled for a long time or perm  */

replace a801=8 if a801==888 /* looking after the home or family */

replace a801=9 if a801==777 /* in military service or social service */



*** Type of leave / Is R on maternity, parental leave or childcare leave

rename a813 a802

*** Worked in the last 7 days / Any paid work in the last 7 days ending last Sunday
 
 rename a814 a805a
  
*** Intention to retire in next 3 years / Intention to retire or take early retirement within next 3 yrs
 
 rename a835 a856
 
*** Hours worked per week / Number of hrs usually working per week 
 
 rename a819 a835
 
*** Job before current activity / Any job/business just before retiring
 
 rename a806 a819
 
*** Opportunity to resume work after leave / Opportunity of resume work after parental leave
 
 rename a815 a806

*** Intention to return to work after leave / Intention to resume work after leave

rename a816a a807a

*** Occupation (ISCO 08) / Current occupation (see code ISCO)

rename a817 a832_1dig


*** Separating Retirement and Homemaking into 2 dummies and respective variables


*** RETIRED

*** Satisfaction with retirement


gen satis_retirem=a804 if a801==6

label variable satis_retirem "Satisfaction with retirement"

label values satis_retirem TSatisfaction

*** Satisfaction with Retirement/Homemaker / How satisfied with being retired (see satisfaction scale)

rename  satis_retirem a817


*** Job before current activity

gen job_before_retirem=a806 if a801==6



label variable job_before_retirem "Job before current activity"

label values job_before_retirem Tyesno

 
rename  a819 renamed
 
rename job_before_retirem a819


*** Intention to take job or start a business

gen intention_job=a805 if a801==6
 
label variable intention_job "Intention to take job or start a business"

label values intention_job Tyesno

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a834 req_retire

*** Full-time or Part-Time / Full-time or part-time job
 
rename  a818 a834


*** Intention to take job or start a business / Intention to take a job within the next 3 yrs

rename intention_job a818


*** HOMEMAKER



*** Satisfaction with being a homemaker


gen satis_home=a804 if a801==8

label variable satis_home "Satisfaction with retirement"

label values satis_home TSatisfaction

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a823 fixed_start_f


*** Satisfaction with Retirement/Homemaker / How satisfied with being retired (see satisfaction scale)

rename  satis_home a823


*** Job before current activity

gen job_before_home=a806 if a801==8



label variable job_before_home "Job before current activity"

label values job_before_home Tyesno

*** Renaming a variable only used in GGS2020 BELARUS (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a825 satisf_work

 
rename job_before_home a825


*** Intention to take job or start a business

gen intention_job_home=a805 if a801==8
 
label variable intention_job_home "Intention to take job or start a business"

label values intention_job_home Tyesno


*** Renaming a variable only used in GGS2020 BELARUS(i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a824 partner_shift_work

rename intention_job_home a824


*** Supervises work of others / Supervision or co-ordination responsibilities

rename a826 a840

*** Organization Type / Business or organization private, public of mixed

rename a827 a842

*** Flexible work arrangements / Employer allows flexible time arrangements for personal reas

rename a829 a844

*** Current contract type / Type of contract

rename a830 a845

*** Number of employees / Number of paid employees

rename a832 a851

*** Work balance: too tired to do chores / I have come home from work too tired to do chores that need to be done

rename a833a a855_a

*** Work balance: difficult to fufill family responsibilities / Difficult fulfill family responsibilities because of amount time spent on job

rename a833b a855_b

*** Work balance: hard to concentrate because of family responsibilities / I have found it difficult concentrate at work due to family responsibilities

rename a833d a855_d

*** Type of Income 1 - 8 / Types of income received during the last 12 months #1 - #8

rename (a841_1 a841_2 a841_3 a841_4 a841_5 a841_6 a841_7 a841_8) (a864_1 a864_2 a864_3 a864_4 a864_5 a864_6 a864_7 a864_8 )

*** Frequency of Payment Type of Income 1 - 8 / Number of payments received last 12 mnths type income 1 - 8

rename (a842_1 a842_2 a842_3 a842_4 a842_5 a842_6 a842_7 a842_8 ) (a865_1 a865_2 a865_3 a865_4 a865_5 a865_6 a865_7 a865_8 )

*** Amount of Payment Type of Income 1 - 8 / Net amount of payment type income 1 - 8 

rename (a843_1 a843_2 a843_3 a843_4 a843_5 a843_6 a843_7 a843_8 ) (a866_1 a866_2 a866_3 a866_4 a866_5 a866_6 a866_7 a866_8 )

*** Partner Activity Status / Partner/spouse's activity

rename a901 a901

*** Partner's Occupation (ISCO 08) / Partner's current occupation (see code ISCO)

rename a914 a921_1dig

*** Partner Full-time or Part-Time / Partner's full-time or part-time

rename a915 a922

*** Partner hours worked per week / Partner's number of hrs usually working per week

rename a916 a923

*** Partner type of Income 1 - 8 / Types of income received by partner during the last 12 months #1 - #8

rename (a929_1 a929_2 a929_3 a929_4 a929_5 a929_6 a929_7 a929_8 ) (a936_1 a936_2 a936_3 a936_4 a936_5 a936_6 a936_7 a936_8 )

*** Frequency of Payment Type of Income 1 - 8 / Number payments received partner last 12 mnths type income 1 - 8 

rename (a930_1 a930_2 a930_3 a930_4 a930_5 a930_6 a930_7 a930_8 ) (a937_1 a937_2 a937_3 a937_4 a937_5 a937_6 a937_7 a937_8 )


*** Amount of Payment Type of Income 1 - 8 / Partner's net amount payment type income 1 - 8

rename (a931_1 a931_2 a931_3 a931_4 a931_5 a931_6 a931_7 a931_8 ) (a938_1 a938_2 a938_3 a938_4 a938_5 a938_6 a938_7 a938_8 ) 

*** Renaming a variable only used in GGS2020 (i.e. no comparable variable in GGS1) to make space///
*** for a variable name for harmonisation

rename a1002 outs_morgag

*** Can make ends meet / HH able to make ends meet

rename a1004 a1002

*** HH can afford: keep house warm / Can hh afford: keeping your home adequately warm

rename a1005a a1003_1

*** HH can afford: weeks holiday / Can hh afford: paying for a week's annual holiday away from home

rename a1005b a1003_2

*** HH can afford: replacing furniture / Can hh afford: replacing any worn-out furniture

rename a1005c a1003_3

*** HH can afford: new clothes / Can hh afford: buying new, rather than second-hand clothes

rename a1005d a1003_4

*** HH can afford: eating meat / Can hh afford: eating meat, chicken or fish every second day

rename a1005e a1003_5

*** HH can afford: entertaining friends and family / Can hh afford: having friends or family for a drink or meal at least once a month

rename a1005f a1003_6

*** HH unable to afford: Rent / HH unable to pay last 12 mnths: rent for accommodation

rename a1006a a1004_1

*** HH unable to afford: Mortgage Payments / HH unable to pay last 12 mnths: mortgage payments

rename a1006b a1004_2

*** HH unable to afford: Bills / HH unable to pay last 12 mnths: utility bills, such as for electricity, water, g

rename a1006c a1004_3

*** HH unable to afford: Debts / HH unable to pay last 12 mnths: purchase installments or other loan repayments

rename a1006d a1004_4

*** Total Household Net Income / Average net income of all hh members during last 12 mnths

rename a1007 a1008

*** General Trust / Opinion about trusting people

rename a1101 a1105

*** Religious Denomination / Religion (should be country-spec. list)

rename a1110 a1101

*** General Fairness / Opinion about fairness of people

rename a1102 a1106

*** Religious Service Attendance / Number of time attending religious service

rename a1111 a1102

*** Care views: Home care for older persons / Opinion: Care for older persons in need of care at their home

rename a1105a a1110_a

*** Care views: Pre-school children / Opinion: Care for pre-school children

rename a1105b a1110_b

*** Care views: School children after school hours / Opinion: Care for schoolchildren during after-school hrs

rename a1105c a1110_c

*** Care views: People below subsistence level / Opinion: Financial support older people below subsistence level

rename a1105d a1110_d

*** Care views: Younger people with children / Opinion: Financial support younger people with children below subsistence level

rename a1105e a1110_e

*** Intergenerational Values: Granparents should provide care / Opinion: Grandparents look after grandchildren if parents are unable to do so

rename a1106a a1111_a

*** Intergenerational Values: Parents provide financial help / Opinion: Parents should provide financial help adult children when in difficulty

rename a1106b a1111_b

*** Intergenerational Values: Parents should adjust to help children / Opinion: If adult children in need, parents adjust own lives to help them

rename a1106c a1111_c

*** Intergenerational Care Values: Children should care for parents / Opinion: Children should take responsibility for parental care if parents in nee

rename a1107a a1112_a

*** Intergenerational Care Values: Children should provide financial help for parent / Opinion: Children should provide financial help if parents financial difficulty

rename a1107b a1112_d

*** Intergenerational Care Values: Children should coreside with parents in need / Opinion: Children should live with parents when no longer look after themselves

rename a1107c a1112_e

* SAVE DATASET 

save "$data\\GGS2020_master.dta", replace


clear

* APPENDING GGS2020 TO GGS1

use "$data\\GGS1_master.dta"

append using "$data\\GGS2020_master.dta"


*** WORK ON GGS1-GGS2020 BELARUS JOINT DATA SET 

*** Labeling acountry 30 Belarus

label define acountry 30 "Belarus", add

*** Reassigning region name labels to Belorusian regions in the data set

label define aregion 1 "Brest", modify
label define aregion 2 "Vitebsk", modify
label define aregion 3 "Gomel", modify
label define aregion 4 "Grodno", modify
label define aregion 5 "Minsk", modify
label define aregion 6 "Mogilev", modify
label define aregion 7 "Minsk City", modify

*** Dropping variables that are not compatible i.e. are different variables in/
*** two data sets but share the same variable name e.g. GGS1 a519 "Is R living with mother?"/
*** and GGS2020 BELARUS a519 "Given help with housework" are different. 

drop a519

drop a536 a537_1 a537_2 a537_3 a537_4 a537_5

drop a831 

drop a820

*** NB: It is important to drop this variable ONLY AFTER APPENDING IS DONE/
*** a804 is used to derive variables for the retired and homemakers in GGS2020,/
*** however, variable a804 captures two different things in GGS1 (How satisfied with leave (see satisfaction scale))
*** and GGS2020 BELARUS (Satisfaction with Retirement/Homemaker) so it has to be dropped after appending

drop a804

drop a703b

drop a317

drop a241

* SAVE DATASET 

save "$data\\GGS1-GGS2020_master.dta", replace
erase "$data\\GGS1_master.dta"
erase "$data\\GGS2020_master.dta"




































 








